import java.awt.BorderLayout;
import java.util.Arrays;

import javax.swing.JFrame;

import vtk.vtkActor;
import vtk.vtkBoxWidget;
import vtk.vtkCanvas;
import vtk.vtkCutter;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkImplicitPlaneWidget;
import vtk.vtkInteractorStyleSwitch;
import vtk.vtkPlane;
import vtk.vtkPointPicker;
import vtk.vtkPolyData;

public class Test6 {
	private vtkBoxWidget boxWidget;
	private vtkImplicitPlaneWidget planeWidget;
	private vtkPlane plane;
	private vtkPointPicker picker;
	private vtkCutter cutter;
	private Test7 test7;


	public void mycb() {
		// planeWidget.SetNormal(0,0,1);
		planeWidget.GetPlane(plane);
	}

	public void pickcb() {
		if (picker.GetPointId() != -1){
			System.out.println(Arrays.toString(((vtkPolyData)picker.GetDataSet()).GetPoints().GetPoint(picker.GetPointId())));
			test7.modify(picker.GetPointId());
		}
		
	}

	public void run() {
		vtkCanvas canvas = new vtkCanvas();
		vtkInteractorStyleSwitch style = new vtkInteractorStyleSwitch();
		style.SetCurrentStyleToTrackballCamera();
		canvas.getIren().SetInteractorStyle(style);

		vtkDataSetReader vrd = new vtkDataSetReader();
		vrd.SetFileName("/home/vtk/Desktop/imageData.vtk");
		vrd.Update();
		vrd.CloseVTKFile();

		cutter = new vtkCutter();
		plane = new vtkPlane();
		plane.SetOrigin(0, 0, 0);
		plane.SetNormal(0, 0, 1);
		cutter.SetCutFunction(plane);
		cutter.SetInput(vrd.GetOutput());
		cutter.GetOutput().Update();

		test7 = new Test7();
		test7.SetInput(cutter.GetOutput());

		// vtkConeSource vcs = new vtkConeSource();
		// vcs.SetResolution(60);

		vtkDataSetMapper vdmp = new vtkDataSetMapper();
		vdmp.SetInput(test7.GetOutput());
		vtkActor vp = new vtkActor();
		vp.SetMapper(vdmp);

		/*
		 * boxWidget = new vtkBoxWidget();
		 * boxWidget.SetInteractor(canvas.getIren());
		 * boxWidget.SetPlaceFactor(1); boxWidget.SetProp3D(va);
		 * boxWidget.PlaceWidget(); boxWidget.AddObserver("InteractionEvent",
		 * this, "mycb"); boxWidget.On();
		 */
		/*
		planeWidget = new vtkImplicitPlaneWidget();
		planeWidget.SetInteractor(canvas.getIren());
		planeWidget.SetPlaceFactor(1);
		planeWidget.SetProp3D(va);
		planeWidget.PlaceWidget();
		planeWidget.DrawPlaneOff();
		planeWidget.AddObserver("InteractionEvent", this, "mycb");
		planeWidget.On();
		planeWidget.ScaleEnabledOff();
		planeWidget.TubingOff();

		planeWidget.GetPlane(plane);
*/
		canvas.GetRenderer().AddActor(vp);
		canvas.GetRenderer().SetBackground(0, 0, 0);
		canvas.GetRenderer().ResetCamera();

		picker = new vtkPointPicker();
		picker.AddObserver("EndPickEvent", this, "pickcb");
		canvas.getIren().SetPicker(picker);

		JFrame f = new JFrame("é");
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setLayout(new BorderLayout());
		f.getContentPane().add(canvas, BorderLayout.CENTER);
		f.setSize(300, 300);
		f.setLocationRelativeTo(null);
		f.setVisible(true);
		//
		canvas.getIren().SetSize(canvas.getSize().width,
				canvas.getSize().height);
	}

	public static void main(String[] args) {
		Test6 tst = new Test6();
		tst.run();
	}
}